#include <bits/stdc++.h>
#define ull unsigned long long
#define MAXN 200005
using namespace std;

int N;
ull A[MAXN];
ull B[MAXN];

namespace case1 // bruteforce
{
  void solve()
  {
    ull max_ans = 0;

    for (int i = 0; i < N; i++)
    {
      ull a = A[i];
      ull b = B[i];
      max_ans = max(max_ans, a * b);
      for (int j = i + 1; j < N; j++)
      {
        a ^= A[j];
        b &= B[j];
        max_ans = max(max_ans, a * b);
      }
    }

    cout << max_ans << "\n";
  }
}

namespace case2 // Ai = 1
{
  void solve()
  {
    ull max_ans = 0;
    for (int i = 0; i < N; i++)
    {
      max_ans = max(max_ans, B[i]);
    }

    cout << max_ans << "\n";
  }
}

namespace case3 // Bi = 1
{
  int BITS = 32;

  struct Trie
  {
    Trie *nodes[2];
    Trie()
    {
      nodes[0] = nodes[1] = nullptr;
    }
  };

  void insert(Trie *root, ull num)
  {
    Trie *current = root;
    for (int i = BITS - 1; i >= 0; --i)
    {
      int bit = (num >> i) & 1;
      if (!current->nodes[bit])
      {
        current->nodes[bit] = new Trie();
      }
      current = current->nodes[bit];
    }
  }

  ull query(Trie *root, ull num)
  {
    Trie *current = root;
    ull max_ans = 0;
    for (int i = BITS - 1; i >= 0; --i)
    {
      int bit = (num >> i) & 1;
      if (current->nodes[1 - bit])
      {
        max_ans |= (1 << i);
        current = current->nodes[1 - bit];
      }
      else
      {
        current = current->nodes[bit];
      }
    }
    return max_ans;
  }

  void solve()
  {
    Trie *root = new Trie();
    insert(root, 0ULL);

    ull max_ans = 0;
    ull pref = 0;
    for (int i = 0; i < N; i++)
    {
      pref ^= A[i];
      insert(root, pref);
      ull ans = query(root, pref);
      if (ans > max_ans)
      {
        max_ans = ans;
      }
    }

    cout << max_ans << "\n";
  }
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  bool case2 = true;
  bool case3 = true;

  cin >> N;
  for (int i = 0; i < N; i++)
  {
    cin >> A[i];
    if (A[i] != 1)
    {
      case2 = false;
    }
  }

  for (int i = 0; i < N; i++)
  {
    cin >> B[i];
    if (B[i] != 1)
    {
      case3 = false;
    }
  }

  if (case2)
  {
    case2::solve();
    return 0;
  }

  if (case3)
  {
    case3::solve();
    return 0;
  }

  case1::solve();
}